<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class UsersSeeder extends Seeder
{
    public function run()
    {
        // Hash password sebelum insert karena insertBatch tidak trigger model callbacks
        $data = [
            [
                'username' => 'admin_activities',
                'email' => 'admin.activities@portfolio.com',
                'password' => password_hash('admin123', PASSWORD_DEFAULT),
                'role' => 'admin_activities',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'username' => 'admin_biodata',
                'email' => 'admin.biodata@portfolio.com',
                'password' => password_hash('admin123', PASSWORD_DEFAULT),
                'role' => 'admin_biodata',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'username' => 'admin_education',
                'email' => 'admin.education@portfolio.com',
                'password' => password_hash('admin123', PASSWORD_DEFAULT),
                'role' => 'admin_education',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];

        // Using DB Query Builder to insert
        $this->db->table('users')->insertBatch($data);
    }
}

